<?php
    /**
    *
    * copyright (c) 2015-2019 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * Classe che consente di creare una tabella
    * 
    */
    class GestoreTabella {
        private $id;
        private $classe;
        private $colonne;
        private $righe;
        
        function __construct($id, $classe, $colonne, $righe = array()) {
            $this->id = $id;
            $this->classe  = $classe;
            $this->colonne = $colonne;
            $this->righe   = $righe;
        }
        
        /*
         * stampa ogni riga della tabella. è possibile specificare se ogni riga deve avere un id
         * che sarà composto dai seguenti parametri:
         * @id: strigna di testo passata in input
         * @posizioneElementoDaUsare: colonna della riga passata in input
         * 
         * ad esempio supponiamo di aver passato come riga un array contenenti id, nome e cognome, ad esempio: array(1,"Mario","Rossi")
         * se al metodo stampa passiamo
         * $id = "cliente"
         * $posizioneElementoDaUsare = 0
         * 
         * la riga avrà come id cliente1 perché ha preso il campo id passato in input più l'elemento alla posizione 0 di questa riga, che vale 1
         */
        function stampa($id="",$posizioneElementoDaUsare=-1) {
            $this->stampaIntestazione();
            foreach($this->righe as $riga) {
                if($id=="") {                
                    $this->stampaRiga($riga);
                }
                else {
                    $this->stampaRiga($riga,$id.$riga[$posizioneElementoDaUsare]);
                }
            }
            echo"</tbody>";
            $this->chiudiTabella();
        }
        
        function stampaIntestazione() {
            echo"<table class=\"$this->classe\"><thead>"; 
            foreach($this->colonne as $colonna) {
                echo"<th>$colonna</th>";
            }
            echo"</thead>";
        }
        
        function stampaRiga($riga,$idRiga="") {
            echo"<tr id=\"$idRiga\">";
            foreach($riga as $elementoRiga) {
                echo"<td>$elementoRiga</td>";
            }
            echo"</tr>";
        }
        
        function chiudiTabella() {
            echo"</table>";
        }
        
        function aggiungiRiga($riga) {
            $this->righe[count($this->righe)] = $riga;
        }
        
        function getId() {
            return $this->id;
        }

        function getColonne() {
            return $this->colonne;
        }

        function getRighe() {
            return $this->righe;
        }

        function setId($id) {
            $this->id = $id;
        }

        function setColonne($colonne) {
            $this->colonne = $colonne;
        }

        function setRighe($righe) {
            $this->righe = $righe;
        }
    }